/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.region;

import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.region.VWConfigStepProcessorInfoCellEditor;
import filenet.vw.toolkit.admin.property.region.VWConfigStepProcessorInfoCellRenderer;
import filenet.vw.toolkit.admin.property.region.VWConfigStepProcessorInfoTableModel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class VWConfigStepProcessorInfoPane
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener {
    private VWSystemConfiguration m_sysConfig = null;
    private VWToolbarBorder m_toolBarBorder = null;
    private VWTable m_stepInfoTable = null;
    private VWConfigStepProcessorInfoTableModel m_tableModel = null;
    private VWConfigStepProcessorInfoCellEditor m_cellEditor = null;

    public VWConfigStepProcessorInfoPane(Frame parentFrame, VWSystemConfiguration sysConfig, VWSessionInfo sessionInfo) {
        try {
            this.m_sysConfig = sysConfig;
            this.createControls(VWResource.StepProcessorInfo, 0x10000010, parentFrame, sessionInfo);
            this.m_stepInfoTable.clearSelection();
            if (this.m_stepInfoTable.getRowCount() > 0) {
                this.m_stepInfoTable.setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int getRowCount() {
        return this.m_tableModel.getRowCount();
    }

    public boolean hasChanged() {
        return this.m_tableModel.hasChanged();
    }

    public boolean stopTableEditing() {
        if (this.m_stepInfoTable != null) {
            this.m_stepInfoTable.stopEditing();
        }
        return true;
    }

    public boolean update() {
        boolean bSuccess = true;
        this.m_stepInfoTable.stopEditing();
        bSuccess = this.m_tableModel.verifyStepProcessorInfoDefinitons();
        if (bSuccess) {
            bSuccess = this.m_tableModel.update();
        }
        return bSuccess;
    }

    public void releaseResources() {
        this.m_sysConfig = null;
        if (this.m_toolBarBorder != null) {
            this.m_toolBarBorder.releaseReferences();
            this.m_toolBarBorder = null;
        }
        if (this.m_stepInfoTable != null) {
            this.m_stepInfoTable.removeAll();
            this.m_stepInfoTable = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.releaseResources();
            this.m_tableModel = null;
        }
        if (this.m_cellEditor != null) {
            this.m_cellEditor.releaseResources();
            this.m_cellEditor = null;
        }
        this.removeAll();
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                if (this.m_stepInfoTable.getRowCount() <= 0) break;
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_stepInfoTable.getSelectedRow()) {
                    this.m_stepInfoTable.clearSelection();
                }
                this.m_stepInfoTable.setRowSelectionInterval(nRow, nRow);
                this.m_stepInfoTable.ensureRowIsVisible(nRow);
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
            int[] nSelectionIndexes = this.m_stepInfoTable.getSelectedRows();
            for (int i = 0; i < nSelectionIndexes.length; ++i) {
                if (nSelectionIndexes[i] != -1 && this.m_tableModel.canDeleteRow(nSelectionIndexes[i])) continue;
                return;
            }
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x10000000));
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 16: {
                    this.stopTableEditing();
                    int nRow = this.m_tableModel.getRowCount();
                    this.m_tableModel.addRow();
                    this.m_stepInfoTable.setRowSelectionInterval(nRow, nRow);
                    this.m_stepInfoTable.setColumnSelectionInterval(0, 0);
                    this.m_stepInfoTable.ensureRowIsVisible(nRow);
                    break;
                }
                case 0x10000000: {
                    this.onDeleteRows();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createControls(String description, int nFlags, Frame parentFrame, VWSessionInfo sessionInfo) {
        try {
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.fill = 1;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(2, 2, 2, 2);
            this.m_toolBarBorder = new VWToolbarBorder(description, nFlags);
            this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
            this.add((Component)this.m_toolBarBorder, gbCons);
            this.createFieldTable(parentFrame, sessionInfo);
            JPanel panel = this.m_toolBarBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JScrollPane(this.m_stepInfoTable), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createFieldTable(Frame parentFrame, VWSessionInfo sessionInfo) {
        int nColWidth = 0;
        try {
            this.m_tableModel = new VWConfigStepProcessorInfoTableModel(this.m_sysConfig, parentFrame);
            this.m_tableModel.addTableModelListener(this);
            this.m_stepInfoTable = new VWTable(this.m_tableModel);
            this.m_stepInfoTable.setRowSelectionAllowed(true);
            this.m_stepInfoTable.getSelectionModel().addListSelectionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_stepInfoTable, this, VWResource.StepProcessorInfoTable, VWResource.StepProcessorInfoTable);
            this.m_stepInfoTable.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_stepInfoTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_stepInfoTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            TableColumn aColumn = this.m_stepInfoTable.getColumn(this.m_stepInfoTable.getColumnName(0));
            aColumn.setCellEditor(this.m_tableModel.getTypeCellEditor());
            aColumn = this.m_stepInfoTable.getColumn(this.m_stepInfoTable.getColumnName(1));
            try {
                nColWidth = Integer.valueOf("100");
            }
            catch (Exception ex) {
                nColWidth = 100;
            }
            aColumn.setMinWidth(nColWidth);
            aColumn = this.m_stepInfoTable.getColumn(this.m_stepInfoTable.getColumnName(2));
            aColumn.setCellEditor(this.m_tableModel.getLanguageCellEditor());
            aColumn = this.m_stepInfoTable.getColumn(this.m_stepInfoTable.getColumnName(3));
            try {
                nColWidth = Integer.valueOf("120");
            }
            catch (Exception ex) {
                nColWidth = 120;
            }
            aColumn.setMinWidth(nColWidth);
            this.m_cellEditor = new VWConfigStepProcessorInfoCellEditor(parentFrame, sessionInfo);
            aColumn.setCellEditor(this.m_cellEditor);
            aColumn.setCellRenderer(new VWConfigStepProcessorInfoCellRenderer());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onDeleteRows() {
        boolean bYesToAll = false;
        try {
            this.stopTableEditing();
            int[] rows = this.m_stepInfoTable.getSelectedRows();
            for (int nIndex = rows.length - 1; nIndex >= 0; --nIndex) {
                String stepInfoName = (String)this.m_tableModel.getValueAt(rows[nIndex], 1);
                if (stepInfoName == null || stepInfoName.length() == 0) {
                    this.m_tableModel.removeRow(rows[nIndex]);
                    this.m_stepInfoTable.updateUI();
                    continue;
                }
                int ret = 0;
                if (!bYesToAll) {
                    Object[] options1 = new Object[]{VWResource.Yes, VWResource.YesToAll, VWResource.No};
                    ret = JOptionPane.showOptionDialog(this, VWResource.ConfirmDeleteStepInfoDef.toString(stepInfoName), null, -1, 3, null, options1, options1[1]);
                    if (ret == 1) {
                        bYesToAll = true;
                    }
                }
                if (ret != 0 && !bYesToAll) continue;
                this.m_tableModel.removeRow(rows[nIndex]);
                this.m_stepInfoTable.updateUI();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

